/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.win32;

import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.StringArray;
import com.sun.jna.ToNativeContext;
import com.sun.jna.TypeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import com.sun.jna.win32.W32APIFunctionMapper$StdCallFunctionMapper;

public class W32APITypeMapper
extends DefaultTypeMapper {
    public static final TypeMapper ASCII;
    public static final TypeMapper UNICODE;
    public static final TypeMapper DEFAULT;

    static {
        UNICODE = new W32APITypeMapper(true);
        ASCII = new W32APITypeMapper(false);
        DEFAULT = Boolean.getBoolean(ToNativeContext.l(W32APIFunctionMapper$StdCallFunctionMapper.b("\u0f52\ud1c3\u3c50\u6143\ud7f5\u7106\u3cab\uc44e\u8eb3"))) ? ASCII : UNICODE;
    }

    protected W32APITypeMapper(boolean unicode) {
        if (unicode) {
            TypeConverter stringConverter = new TypeConverter(){

                @Override
                public Object fromNative(Object value, FromNativeContext context) {
                    if (value == null) {
                        return null;
                    }
                    return value.toString();
                }

                @Override
                public Class<?> nativeType() {
                    return WString.class;
                }

                @Override
                public Object toNative(Object value, ToNativeContext context) {
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof String[]) {
                        return new StringArray((String[])value, true);
                    }
                    return new WString(value.toString());
                }
            };
            this.addTypeConverter(String.class, stringConverter);
            this.addToNativeConverter(String[].class, stringConverter);
        }
        TypeConverter booleanConverter = new TypeConverter(){

            @Override
            public Class<?> nativeType() {
                return Integer.class;
            }

            @Override
            public Object fromNative(Object value, FromNativeContext context) {
                return (Integer)value != 0 ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Object toNative(Object value, ToNativeContext context) {
                return Boolean.TRUE.equals(value) ? 1 : 0;
            }
        };
        this.addTypeConverter(Boolean.class, booleanConverter);
    }
}

